<?php

/**
 * Class that operate on table 'cashtransfer'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-12-07 10:44
 */
class CashtransferMySqlExtDAO extends CashtransferMySqlDAO {

    public function loadExt($id) {
        $sql = 'SELECT c.*, b.bankname, a.accountname,a.bankid,a.accountnumber, s.savename
				FROM cashtransfer c
				JOIN  bankaccount a ON a.accountid = c.bankaccountid
				JOIN  bank b ON b.bankid = a.bankid
				JOIN save s
				ON c.saveid = s.saveid
				WHERE c.cashtransferid=' . $id . '
				ORDER BY c.cashtransferdate DESC ';
        $sqlQuery = new SqlQuery($sql);
        return $this->getRow($sqlQuery);
    }

    public function queryCashTransferBydate($from, $to) {
        $sql = 'SELECT c.*, b.bankname, a.accountname,a.bankid, s.savename,a.accountnumber
		FROM cashtransfer c
		JOIN  bankaccount a ON a.accountid = c.bankaccountid
		JOIN  bank b ON b.bankid = a.bankid
		JOIN save s	ON c.saveid = s.saveid
		where c.cashtransferdate >= "' . $from . '"  and c.cashtransferdate <= "' . $to . '"
		ORDER BY c.cashtransferdate  desc';

        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryCashTransferBySaveId($saveId) {
        $sql = 'SELECT c.*, b.bankname, a.accountname,a.bankid, s.savename,a.accountnumber
		FROM cashtransfer c
		JOIN  bankaccount a ON a.accountid = c.bankaccountid
		JOIN  bank b ON b.bankid = a.bankid
		JOIN save s	ON c.saveid = s.saveid
		where c.saveid = ' . $saveId . '
		ORDER BY c.cashtransferdate  desc';

        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function updateConditions($cashtransfer) {
        $sql = 'UPDATE cashtransfer SET userid = ?, conditions = ? WHERE cashtransferid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($cashtransfer->userid);
        $sqlQuery->setNumber($cashtransfer->conditions);

        $sqlQuery->setNumber($cashtransfer->cashtransferid);
        return $this->executeUpdate($sqlQuery);
    }

    public function selectByAccIdAndChckNo($accid, $chckno) {
        $sql = 'select * from cashtransfer where bankaccountid = "' . $accid . '"  cashtransfernumber = ' . $chckno;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

}

?>